package gov.va.vamf.scheduling.direct.datalayer.user;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.va.mpi.PatientCorrelationGateway;
import com.google.common.base.Preconditions;

import javax.annotation.Resource;

public class VarPatientCorrelationGateway {

    @Resource
    protected PatientCorrelationGateway patientCorrelationGateway;
    
    public PatientIdentifiers getCorrespondIdentifiers(final PatientIdentifier patientIdentifier) {

        if (System.getenv("mock.mvi").equalsIgnoreCase("true")) {
            // we are set to mock, return IDs for pw_redacted
            PatientIdentifiers ids = new PatientIdentifiers();
            //ids.add(new PatientIdentifier("ICN", "1006088937"));
            //ids.add(new PatientIdentifier("dfn-516", "7188450"));
            //ids.add(new PatientIdentifier("dfn-631", "7188450"));
            //ids.add(new PatientIdentifier("EDIPI", "1113138327"));

            //ids.add(new PatientIdentifier("ICN", "5000000357"));
            ids.add(new PatientIdentifier("ICN", "1006088937"));
            ids.add(new PatientIdentifier("dfn-523", "100718"));

            return ids;
        }

        return patientCorrelationGateway.getCorrespondIdentifiers(patientIdentifier);
    }

}